//
//  Arkestra_AuV3DSPKernel.hpp
//  Arkestra AuV3
//
//  Created by Isak Burström on 2024-06-05.
//

#pragma once

#import <AudioToolbox/AudioToolbox.h>
#import <CoreMIDI/CoreMIDI.h>
#import <algorithm>
#import <vector>
#import <span>

#import "Arkestra_AuV3-Swift.h"
#import "Arkestra_AuV3ParameterAddresses.h"

/*
 Arkestra_AuV3DSPKernel
 As a non-ObjC class, this is safe to use from render thread.
 */
class Arkestra_AuV3DSPKernel {
public:
    void initialize(int inputChannelCount, int outputChannelCount, double inSampleRate) {
        mSampleRate = inSampleRate;
    }
    
    void deInitialize() {
    }
    
    // MARK: - Bypass
    bool isBypassed() {
        return mBypassed;
    }
    
    void setBypass(bool shouldBypass) {
        mBypassed = shouldBypass;
    }
    
    // MARK: - Parameter Getter / Setter
    // Add a case for each parameter in Arkestra_AuV3ParameterAddresses.h
    void setParameter(AUParameterAddress address, AUValue value) {
        switch (address) {
            case Arkestra_AuV3ParameterAddress::fader_1:
                mFader_1 = value;
            case Arkestra_AuV3ParameterAddress::fader_2:
                mFader_2 = value;
            case Arkestra_AuV3ParameterAddress::fader_3:
                mFader_3 = value;
            case Arkestra_AuV3ParameterAddress::fader_4:
                mFader_4 = value;
            case Arkestra_AuV3ParameterAddress::fader_5:
                mFader_5 = value;
            case Arkestra_AuV3ParameterAddress::fader_6:
                mFader_6 = value;
            case Arkestra_AuV3ParameterAddress::fader_7:
                mFader_7 = value;
            case Arkestra_AuV3ParameterAddress::fader_8:
                mFader_8 = value;
        
            case Arkestra_AuV3ParameterAddress::mod1_1:
                mMod1_1 = value;
            case Arkestra_AuV3ParameterAddress::mod1_2:
                mMod1_2 = value;
            case Arkestra_AuV3ParameterAddress::mod1_3:
                mMod1_3 = value;
            case Arkestra_AuV3ParameterAddress::mod1_4:
                mMod1_4 = value;
            case Arkestra_AuV3ParameterAddress::mod1_5:
                mMod1_5 = value;
            case Arkestra_AuV3ParameterAddress::mod1_6:
                mMod1_6 = value;
            case Arkestra_AuV3ParameterAddress::mod1_7:
                mMod1_7 = value;
            case Arkestra_AuV3ParameterAddress::mod1_8:
                mMod1_8 = value;
        
            case Arkestra_AuV3ParameterAddress::mod2_1:
                mMod2_1 = value;
            case Arkestra_AuV3ParameterAddress::mod2_2:
                mMod2_2 = value;
            case Arkestra_AuV3ParameterAddress::mod2_3:
                mMod2_3 = value;
            case Arkestra_AuV3ParameterAddress::mod2_4:
                mMod2_4 = value;
            case Arkestra_AuV3ParameterAddress::mod2_5:
                mMod2_5 = value;
            case Arkestra_AuV3ParameterAddress::mod2_6:
                mMod2_6 = value;
            case Arkestra_AuV3ParameterAddress::mod2_7:
                mMod2_7 = value;
            case Arkestra_AuV3ParameterAddress::mod2_8:
                mMod2_8 = value;
                
        
            case Arkestra_AuV3ParameterAddress::mod3_1:
                mMod3_1 = value;
            case Arkestra_AuV3ParameterAddress::mod3_2:
                mMod3_2 = value;
            case Arkestra_AuV3ParameterAddress::mod3_3:
                mMod3_3 = value;
            case Arkestra_AuV3ParameterAddress::mod3_4:
                mMod3_4 = value;
            case Arkestra_AuV3ParameterAddress::mod3_5:
                mMod3_5 = value;
            case Arkestra_AuV3ParameterAddress::mod3_6:
                mMod3_6 = value;
            case Arkestra_AuV3ParameterAddress::mod3_7:
                mMod3_7 = value;
            case Arkestra_AuV3ParameterAddress::mod3_8:
                mMod3_8 = value;
                
            case Arkestra_AuV3ParameterAddress::speed:
                mSpeed = value;
            case Arkestra_AuV3ParameterAddress::color:
                mColor = value;
            case Arkestra_AuV3ParameterAddress::master:
                mMaster = value;
        }
    }
    
    AUValue getParameter(AUParameterAddress address) {
        // Return the goal. It is not thread safe to return the ramping value.
        
        switch (address) {
            case Arkestra_AuV3ParameterAddress::fader_1:
                return (AUValue)mFader_1;
            case Arkestra_AuV3ParameterAddress::fader_2:
                return (AUValue)mFader_2;
            case Arkestra_AuV3ParameterAddress::fader_3:
                return (AUValue)mFader_3;
            case Arkestra_AuV3ParameterAddress::fader_4:
                return (AUValue)mFader_4;
            case Arkestra_AuV3ParameterAddress::fader_5:
                return (AUValue)mFader_5;
            case Arkestra_AuV3ParameterAddress::fader_6:
                return (AUValue)mFader_6;
            case Arkestra_AuV3ParameterAddress::fader_7:
                return (AUValue)mFader_7;
            case Arkestra_AuV3ParameterAddress::fader_8:
                return (AUValue)mFader_8;
        
            case Arkestra_AuV3ParameterAddress::mod1_1:
                return (AUValue)mMod1_1;
            case Arkestra_AuV3ParameterAddress::mod1_2:
                return (AUValue)mMod1_2;
            case Arkestra_AuV3ParameterAddress::mod1_3:
                return (AUValue)mMod1_3;
            case Arkestra_AuV3ParameterAddress::mod1_4:
                return (AUValue)mMod1_4;
            case Arkestra_AuV3ParameterAddress::mod1_5:
                return (AUValue)mMod1_5;
            case Arkestra_AuV3ParameterAddress::mod1_6:
                return (AUValue)mMod1_6;
            case Arkestra_AuV3ParameterAddress::mod1_7:
                return (AUValue)mMod1_7;
            case Arkestra_AuV3ParameterAddress::mod1_8:
                return (AUValue)mMod1_8;
        
        
            case Arkestra_AuV3ParameterAddress::mod2_1:
                return (AUValue)mMod2_1;
            case Arkestra_AuV3ParameterAddress::mod2_2:
                return (AUValue)mMod2_2;
            case Arkestra_AuV3ParameterAddress::mod2_3:
                return (AUValue)mMod2_3;
            case Arkestra_AuV3ParameterAddress::mod2_4:
                return (AUValue)mMod2_4;
            case Arkestra_AuV3ParameterAddress::mod2_5:
                return (AUValue)mMod2_5;
            case Arkestra_AuV3ParameterAddress::mod2_6:
                return (AUValue)mMod2_6;
            case Arkestra_AuV3ParameterAddress::mod2_7:
                return (AUValue)mMod2_7;
            case Arkestra_AuV3ParameterAddress::mod2_8:
                return (AUValue)mMod2_8;
        
            case Arkestra_AuV3ParameterAddress::mod3_1:
                return (AUValue)mMod3_1;
            case Arkestra_AuV3ParameterAddress::mod3_2:
                return (AUValue)mMod3_2;
            case Arkestra_AuV3ParameterAddress::mod3_3:
                return (AUValue)mMod3_3;
            case Arkestra_AuV3ParameterAddress::mod3_4:
                return (AUValue)mMod3_4;
            case Arkestra_AuV3ParameterAddress::mod3_5:
                return (AUValue)mMod3_5;
            case Arkestra_AuV3ParameterAddress::mod3_6:
                return (AUValue)mMod3_6;
            case Arkestra_AuV3ParameterAddress::mod3_7:
                return (AUValue)mMod3_7;
            case Arkestra_AuV3ParameterAddress::mod3_8:
                return (AUValue)mMod3_8;
                
            case Arkestra_AuV3ParameterAddress::speed:
                return (AUValue)mSpeed;
            case Arkestra_AuV3ParameterAddress::color:
                return (AUValue)mColor;
            case Arkestra_AuV3ParameterAddress::master:
                return (AUValue)mMaster;
                
            default: return 0.f;
        }
    }
    
    // MARK: - Max Frames
    AUAudioFrameCount maximumFramesToRender() const {
        return mMaxFramesToRender;
    }
    
    void setMaximumFramesToRender(const AUAudioFrameCount &maxFrames) {
        mMaxFramesToRender = maxFrames;
    }
    
    // MARK: - Musical Context
    void setMusicalContextBlock(AUHostMusicalContextBlock contextBlock) {
        mMusicalContextBlock = contextBlock;
    }
    
    // MARK: - MIDI Protocol
    MIDIProtocolID AudioUnitMIDIProtocol() const {
        return kMIDIProtocol_2_0;
    }
    
    /**
     MARK: - Internal Process
     
     This function does the core siginal processing.
     Do your custom DSP here.
     */
    void process(std::span<float const*> inputBuffers, std::span<float *> outputBuffers, AUEventSampleTime bufferStartTime, AUAudioFrameCount frameCount) {
        if (mBypassed) {
            // Fill the 'outputBuffers' with silence
            for (UInt32 channel = 0; channel < outputBuffers.size(); ++channel) {
                std::fill_n(outputBuffers[channel], frameCount, 0.f);
            }
            return;
        }
        
        /*
         Note: For an Audio Unit with 'n' input channels to 'n' output channels, remove the assert below and
         modify the check in [Arkestra_AuV3AudioUnit allocateRenderResourcesAndReturnError]
         */
        assert(inputBuffers.size() == outputBuffers.size());
        
        
        
        // Use this to get Musical context info from the Plugin Host,
        // Replace nullptr with &memberVariable according to the AUHostMusicalContextBlock function signature
        if (mMusicalContextBlock) {
            mMusicalContextBlock(nullptr /* currentTempo */,
                                 nullptr /* timeSignatureNumerator */,
                                 nullptr /* timeSignatureDenominator */,
                                 nullptr /* currentBeatPosition */,
                                 nullptr /* sampleOffsetToNextBeat */,
                                 nullptr /* currentMeasureDownbeatPosition */);
        }
        
        // Perform per sample dsp on the incoming float in before assigning it to out
        for (UInt32 channel = 0; channel < inputBuffers.size(); ++channel) {
            for (UInt32 frameIndex = 0; frameIndex < frameCount; ++frameIndex) {
                
                // Do your sample by sample dsp here...
                outputBuffers[channel][frameIndex] = inputBuffers[channel][frameIndex];
                
            }
        }
    }
    
    void handleOneEvent(AUEventSampleTime now, AURenderEvent const *event) {
        switch (event->head.eventType) {
            case AURenderEventParameter: {
                handleParameterEvent(now, event->parameter);
                break;
            }
                
            case AURenderEventMIDIEventList: {
                handleMIDIEventList(now, &event->MIDIEventsList);
                break;
            }
                
            default:
                break;
        }
    }
    
    void handleParameterEvent(AUEventSampleTime now, AUParameterEvent const& parameterEvent) {
        // Implement handling incoming Parameter events as needed
        setParameter(parameterEvent.parameterAddress, parameterEvent.value);

//        switch(parameterEvent.eventType) {
//            case AURenderEventParameter: {
//                setParameter(parameterEvent.parameterAddress, parameterEvent.value)
//                break;
//            }
//            case AURenderEventParameterRamp: {
//                setParameter(parameterEvent.parameterAddress, parameterEvent.value)
//                break;
//            }
//            case AURenderEventMIDI: {
//                break;
//            }
//            case AURenderEventMIDISysEx: {
//                break;
//            }
//            case AURenderEventMIDIEventList: {
//                break;
//            }
//        }
    }
    
    void handleMIDIEventList(AUEventSampleTime now, AUMIDIEventList const* midiEvent) {
        auto visitor = [] (void* context, MIDITimeStamp timeStamp, MIDIUniversalMessage message) {
            auto thisObject = static_cast<Arkestra_AuV3DSPKernel *>(context);
            
            switch (message.type) {
                case kMIDIMessageTypeChannelVoice2: {
                    thisObject->handleMIDI2VoiceMessage(message);
                }
                    break;
                    
                default:
                    break;
            }
        };
        
        MIDIEventListForEachEvent(&midiEvent->eventList, visitor, this);
    }
    
    void handleMIDI2VoiceMessage(const struct MIDIUniversalMessage& message) {
        //const auto& note = message.channelVoice2.note;
//
//        switch (message.channelVoice2.status) {
//            case kMIDICVStatusNoteOff: {
//                mNoteEnvelope = 0.0;
//            }
//                break;
//
//            case kMIDICVStatusNoteOn: {
//                mNoteEnvelope = 1.0;
//            }
//                break;
//
//            default:
//                break;
//        }
    }
    
    // MARK: - Member Variables
    AUHostMusicalContextBlock mMusicalContextBlock;
    
    double mSampleRate = 44100.0;
    double mFader_1 = 1.0;
    double mFader_2 = 1.0;
    double mFader_3 = 1.0;
    double mFader_4 = 1.0;
    double mFader_5 = 1.0;
    double mFader_6 = 1.0;
    double mFader_7 = 1.0;
    double mFader_8 = 1.0;
    
    
    double mMod1_1 = 1.0;
    double mMod1_2 = 1.0;
    double mMod1_3 = 1.0;
    double mMod1_4 = 1.0;
    double mMod1_5 = 1.0;
    double mMod1_6 = 1.0;
    double mMod1_7 = 1.0;
    double mMod1_8 = 1.0;
    
    double mMod2_1 = 1.0;
    double mMod2_2 = 1.0;
    double mMod2_3 = 1.0;
    double mMod2_4 = 1.0;
    double mMod2_5 = 1.0;
    double mMod2_6 = 1.0;
    double mMod2_7 = 1.0;
    double mMod2_8 = 1.0;
    
    double mMod3_1 = 1.0;
    double mMod3_2 = 1.0;
    double mMod3_3 = 1.0;
    double mMod3_4 = 1.0;
    double mMod3_5 = 1.0;
    double mMod3_6 = 1.0;
    double mMod3_7 = 1.0;
    double mMod3_8 = 1.0;
    
    double mSpeed = 1.0;
    double mColor = 1.0;
    double mMaster = 1.0;
    
    bool mBypassed = false;
    AUAudioFrameCount mMaxFramesToRender = 1024;
};
